<?php
/*--------------------------------------------------------------------------------------------------
    Provider.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\Database;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Properties\Database\Readers\Interfaces\PropertyReaderInterface;
use Gambio\Shop\Properties\Database\Readers\PropertyReader;
use Gambio\Shop\Properties\Database\Repositories\Interfaces\PropertyReadRepositoryInterface;
use Gambio\Shop\Properties\Database\Repositories\PropertyReadRepository;
use Gambio\Shop\Properties\Database\Services\Interfaces\PropertiesReaderServiceInterface;
use Gambio\Shop\Properties\Database\Services\PropertiesReaderService;
use League\Container\ServiceProvider\AbstractServiceProvider;

class ServiceProvider extends AbstractServiceProvider
{
    /**
     * @var array
     */
    protected $provides = [
        PropertiesReaderServiceInterface::class
    ];
    
    
    /**
     * @inheritDoc
     */
    public function register()
    {
        $this->container->share(PropertiesReaderServiceInterface::class, PropertiesReaderService::class)
                        ->addArgument(PropertyReadRepositoryInterface::class);
        
        $this->container->share(PropertyReadRepositoryInterface::class, PropertyReadRepository::class)
                        ->addArgument(PropertyReaderInterface::class);
        
        $this->container->share(PropertyReaderInterface::class, PropertyReader::class)->addArgument(Connection::class);
        
        $this->container->share(PropertiesReaderServiceInterface::class, PropertiesReaderService::class);
        $this->container->share(PropertiesReaderService::class);
    }
}